attribute vec2 coord_xz;
attribute float coord_y;

uniform mat4 mvp, m;
uniform mat4 v_inv;

varying vec2 f_texcoord_foam, f_texcoord_effect;

varying float f_mainSpecularFactor;
varying float f_pos_factor;

attribute float factor_alpha;
varying float f_factor_alpha;

#ifdef MULTI_TEX
attribute float factor_foam;
varying float f_factor_foam;
#endif

attribute float factor_period_index;
uniform vec4 period_factor;
uniform float flow_counter;

varying float f_effect_factor;


#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
uniform mat4 v;
#endif


void main(void)
{
	//Position
	vec4 coord = vec4(coord_xz.x, coord_y, coord_xz.y, 1.0);
	vec4 positionWorld = m * coord;
	gl_Position = mvp * coord;

	//Towards Fragment Shader
	f_factor_alpha = factor_alpha;

	const int vec4Size = 4;
	int periodIndex = int(factor_period_index);
	float periodFactor = period_factor[periodIndex];
	float periodFactorAlt = period_factor[vec4Size-1-periodIndex];
	f_effect_factor = periodFactor;

	vec2 wobbleStrength = vec2(0.6, 0.3);
	vec2 wobbleFactor = vec2(periodFactor*2.0-1.0, periodFactorAlt*2.0-1.0) * wobbleStrength;
	vec2 coordXZ = vec2(coord.x, coord.z);
	f_texcoord_foam = coordXZ * TEX_COORD_SCALE*WATER_FOAM_SCALE;
	f_texcoord_effect = (coordXZ+wobbleFactor) * WATER_EFFECT_SCALE;
	f_texcoord_effect.y += flow_counter;

#ifdef MULTI_TEX
	f_factor_foam = factor_foam;
#endif

	//Light
	vec3 viewDirection = getViewDirection(v_inv, positionWorld);
	vec2 mainSpecLightDirection = normalize(vec2(currentLight.position.x, currentLight.position.z));
	vec2 mainSpecViewDirection = normalize(vec2(viewDirection.x, viewDirection.z));

	f_mainSpecularFactor = max(0.0, dot(-mainSpecLightDirection, mainSpecViewDirection));
	f_mainSpecularFactor = pow(f_mainSpecularFactor, 32.0);

	float zDiff = max(0.0, positionWorld.z-(EXT_AREA_START-EXT_AREA_WIDTH));
	f_pos_factor = 1.0 - zDiff/(2.0*EXT_AREA_WIDTH);
	f_pos_factor *= f_pos_factor;

#ifdef FOG
	f_fogFactor = getFogFactor(v, positionWorld);
	f_fogFactorGround = getFogFactorGround(f_fogFactor, positionWorld);
#endif
}
